/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.service.AreaService;
import com.kuaike.scrm.common.service.dto.resp.AreaDto;
import com.kuaike.scrm.dal.area.entity.Area;
import com.kuaike.scrm.dal.area.entity.Phone;
import com.kuaike.scrm.dal.area.mapper.AreaMapper;
import com.kuaike.scrm.dal.area.mapper.PhoneMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AreaServiceImpl
implements AreaService {
    private static final Logger log = LoggerFactory.getLogger(AreaServiceImpl.class);
    Map<String, AreaDto> cache = Maps.newHashMap();
    Map<String, List<AreaDto>> childrenCache = Maps.newHashMap();
    Map<String, String> fullNameCache = Maps.newHashMap();
    List<AreaDto> province = Lists.newArrayList();
    @Autowired
    private AreaMapper areaMapper;
    @Autowired
    private PhoneMapper phoneMapper;

    @PostConstruct
    public void init() {
        long time = System.currentTimeMillis();
        List list = this.areaMapper.getAll();
        HashSet directCities = Sets.newHashSet((Object[])new String[]{"110100", "120100", "310100", "500100"});
        for (Area it : list) {
            AreaDto dto = new AreaDto(it.getCode(), it.getName(), it.getPcode(), it.getLevel().intValue());
            this.cache.put(it.getCode(), dto);
            if (it.getLevel() <= 1) {
                this.fullNameCache.put(it.getCode(), it.getName());
            } else {
                String parentName = this.fullNameCache.get(it.getPcode());
                if (directCities.contains(it.getCode())) {
                    this.fullNameCache.put(it.getCode(), parentName);
                    it.setName(parentName);
                } else {
                    this.fullNameCache.put(it.getCode(), parentName + "-" + it.getName());
                }
            }
            if (it.getLevel() == 1) {
                this.province.add(dto);
            }
            List children = this.childrenCache.computeIfAbsent(it.getPcode(), k -> Lists.newArrayList());
            children.add(dto);
        }
        time = System.currentTimeMillis() - time;
        log.info("Area cache is initialized in {} ms.", (Object)time);
    }

    public String getName(String code) {
        AreaDto area = this.cache.get(code);
        if (area == null) {
            log.warn("area not exist:{}", (Object)code);
            return null;
        }
        return area.getName();
    }

    public Map<String, String> getNames(Collection<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            log.warn("area codes is empty");
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMap();
        for (String code : codes) {
            AreaDto area = this.cache.get(code);
            if (area == null) continue;
            map.put(code, area.getName());
        }
        return map;
    }

    public String getFullName(String code) {
        return this.fullNameCache.get(code);
    }

    public Map<String, String> getFullNames(Collection<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMap();
        for (String code : codes) {
            if (code == null) continue;
            map.put(code, this.fullNameCache.get(code));
        }
        return map;
    }

    public List<String> getChildrenIds(String code, boolean containSelf) {
        List<AreaDto> children;
        AreaDto area = this.cache.get(code);
        if (area == null) {
            log.warn("area node found:{}", (Object)code);
            return Collections.emptyList();
        }
        if (area.getLevel() >= 3) {
            if (containSelf) {
                return Collections.singletonList(code);
            }
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        if (containSelf) {
            result.add(code);
        }
        if (CollectionUtils.isNotEmpty(children = this.childrenCache.get(code))) {
            children.forEach(it -> result.add(it.getId()));
        }
        if (area.getLevel() == 2) {
            return result;
        }
        if (CollectionUtils.isNotEmpty(children)) {
            for (AreaDto it2 : children) {
                List<AreaDto> region = this.childrenCache.get(it2.getId());
                if (!CollectionUtils.isNotEmpty(region)) continue;
                region.forEach(r -> result.add(r.getId()));
            }
        }
        return result;
    }

    public List<String> getDirectChildrenIds(String code, boolean containSelf) {
        List<AreaDto> children;
        AreaDto area = this.cache.get(code);
        if (area == null) {
            log.warn("area node found:{}", (Object)code);
            return Collections.emptyList();
        }
        if (area.getLevel() >= 3) {
            if (containSelf) {
                return Collections.singletonList(code);
            }
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        if (containSelf) {
            result.add(code);
        }
        if (CollectionUtils.isNotEmpty(children = this.childrenCache.get(code))) {
            children.forEach(it -> result.add(it.getId()));
        }
        return result;
    }

    public Map<String, List<String>> getDirectChildrenIds(List<String> ids, boolean containSelf) {
        HashMap codes = Maps.newHashMap();
        for (String code : ids) {
            codes.put(code, this.getDirectChildrenIds(code, containSelf));
        }
        return codes;
    }

    public List<AreaDto> getProvince() {
        return this.province;
    }

    public List<AreaDto> getChildren(String code) {
        return this.childrenCache.get(code);
    }

    public Map<String, AreaDto> getAll() {
        return this.cache;
    }

    public String getIdByMobile(String mobile) {
        String segment = this.getMobileSegment(mobile);
        if (segment == null) {
            return null;
        }
        Phone phone = this.phoneMapper.getByPhone(segment);
        if (phone != null) {
            return phone.getAreaCode();
        }
        return null;
    }

    public Map<String, String> getIdByMobiles(Collection<String> mobiles) {
        if (CollectionUtils.isEmpty(mobiles)) {
            return Collections.emptyMap();
        }
        HashSet<String> segments = new HashSet<String>();
        HashMap segmentMap = Maps.newHashMap();
        for (String mobile : mobiles) {
            String segment = this.getMobileSegment(mobile);
            if (segment == null) continue;
            segments.add(segment);
            segmentMap.put(mobile, segment);
        }
        if (CollectionUtils.isEmpty(segments)) {
            return Collections.emptyMap();
        }
        List list = this.phoneMapper.getByPhones(segments);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        Map<String, String> areaMap = list.stream().collect(Collectors.toMap(Phone::getPhone, Phone::getAreaCode));
        HashMap result = Maps.newHashMap();
        for (String mobile : mobiles) {
            String areaCode;
            String segment = (String)segmentMap.get(mobile);
            if (segment == null || (areaCode = areaMap.get(segment)) == null) continue;
            result.put(mobile, areaCode);
        }
        return result;
    }
}

