/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.dto;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.OrderNotifyTargetType;
import com.kuaike.scrm.common.enums.OrderNotifyType;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class NotificationConfigDto
implements Serializable {
    private Long bizId;
    private Integer open;
    private Integer type;
    private Integer delay;
    @Deprecated
    private String content;
    private Integer targetType;
    private String targets;
    private String targetNames;

    public NotificationConfigDto(Long bizId, Integer open, Integer type) {
        this.bizId = bizId;
        this.open = open;
        this.type = type;
    }

    public void validate() {
        Preconditions.checkArgument((this.open != null && (this.open == 0 || this.open == 1) ? 1 : 0) != 0, (Object)"\u901a\u77e5\u5f00\u542f\u5173\u95ed\u53c2\u6570\u4e3a\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u53ea\u80fd\u662f0\u6216\u80051");
        Preconditions.checkArgument((boolean)OrderNotifyType.contain((Integer)this.type), (Object)"type\u53c2\u6570\u9519\u8bef");
        if (this.open == 1) {
            if (this.type.intValue() == OrderNotifyType.NO_PAY.getValue()) {
                Preconditions.checkArgument((this.delay != null && this.delay > 0 ? 1 : 0) != 0, (Object)"\u901a\u77e5\u5ef6\u8fdf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u8981\u5927\u4e8e0");
                Preconditions.checkArgument((this.delay <= 4320 ? 1 : 0) != 0, (Object)"\u901a\u77e5\u5ef6\u8fdf\u65f6\u95f4\u6700\u957f\u4e0d\u8d85\u8fc7\u4e09\u5929");
            } else if (this.type.intValue() == OrderNotifyType.MEETING_FINISH_PAY.getValue()) {
                Preconditions.checkArgument((boolean)OrderNotifyTargetType.in((Integer)this.targetType, (OrderNotifyTargetType[])new OrderNotifyTargetType[]{OrderNotifyTargetType.INVITE, OrderNotifyTargetType.BIND, OrderNotifyTargetType.DESIGNATE}), (Object)"\u901a\u77e5\u4eba\u7c7b\u578b\u9519\u8bef");
            } else {
                Preconditions.checkArgument((boolean)OrderNotifyTargetType.in((Integer)this.targetType, (OrderNotifyTargetType[])new OrderNotifyTargetType[]{OrderNotifyTargetType.BIND, OrderNotifyTargetType.DESIGNATE}), (Object)"\u901a\u77e5\u4eba\u7c7b\u578b\u9519\u8bef");
            }
            if (this.targetType != null && (this.targetType & OrderNotifyTargetType.DESIGNATE.getValue()) != 0) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.targets), (Object)"\u6307\u5b9a\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    public Long getBizId() {
        return this.bizId;
    }

    public Integer getOpen() {
        return this.open;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getDelay() {
        return this.delay;
    }

    @Deprecated
    public String getContent() {
        return this.content;
    }

    public Integer getTargetType() {
        return this.targetType;
    }

    public String getTargets() {
        return this.targets;
    }

    public String getTargetNames() {
        return this.targetNames;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public void setOpen(Integer open) {
        this.open = open;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    @Deprecated
    public void setContent(String content) {
        this.content = content;
    }

    public void setTargetType(Integer targetType) {
        this.targetType = targetType;
    }

    public void setTargets(String targets) {
        this.targets = targets;
    }

    public void setTargetNames(String targetNames) {
        this.targetNames = targetNames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationConfigDto)) {
            return false;
        }
        NotificationConfigDto other = (NotificationConfigDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$bizId = this.getBizId();
        Long other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !((Object)this$bizId).equals(other$bizId)) {
            return false;
        }
        Integer this$open = this.getOpen();
        Integer other$open = other.getOpen();
        if (this$open == null ? other$open != null : !((Object)this$open).equals(other$open)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$delay = this.getDelay();
        Integer other$delay = other.getDelay();
        if (this$delay == null ? other$delay != null : !((Object)this$delay).equals(other$delay)) {
            return false;
        }
        Integer this$targetType = this.getTargetType();
        Integer other$targetType = other.getTargetType();
        if (this$targetType == null ? other$targetType != null : !((Object)this$targetType).equals(other$targetType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$targets = this.getTargets();
        String other$targets = other.getTargets();
        if (this$targets == null ? other$targets != null : !this$targets.equals(other$targets)) {
            return false;
        }
        String this$targetNames = this.getTargetNames();
        String other$targetNames = other.getTargetNames();
        return !(this$targetNames == null ? other$targetNames != null : !this$targetNames.equals(other$targetNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NotificationConfigDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : ((Object)$bizId).hashCode());
        Integer $open = this.getOpen();
        result = result * 59 + ($open == null ? 43 : ((Object)$open).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $delay = this.getDelay();
        result = result * 59 + ($delay == null ? 43 : ((Object)$delay).hashCode());
        Integer $targetType = this.getTargetType();
        result = result * 59 + ($targetType == null ? 43 : ((Object)$targetType).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $targets = this.getTargets();
        result = result * 59 + ($targets == null ? 43 : $targets.hashCode());
        String $targetNames = this.getTargetNames();
        result = result * 59 + ($targetNames == null ? 43 : $targetNames.hashCode());
        return result;
    }

    public String toString() {
        return "NotificationConfigDto(bizId=" + this.getBizId() + ", open=" + this.getOpen() + ", type=" + this.getType() + ", delay=" + this.getDelay() + ", content=" + this.getContent() + ", targetType=" + this.getTargetType() + ", targets=" + this.getTargets() + ", targetNames=" + this.getTargetNames() + ")";
    }

    public NotificationConfigDto() {
    }
}

