package com.kuaike.trace.registrar;

import com.google.common.collect.Maps;
import com.kuaike.trace.config.EnableTraceId;
import com.kuaike.trace.constants.TraceConstants;
import com.kuaike.trace.interceptor.KafkaConsumerInterceptor;
import com.kuaike.trace.utils.TraceIdUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.*;
import org.springframework.core.type.AnnotationMetadata;

import java.util.Map;
import java.util.Objects;


/**
 * @author louis
 * @date 2022/8/2
 */
public class TraceIdScanRegistrar implements ImportBeanDefinitionRegistrar,ApplicationContextAware,EnvironmentAware {


    private ApplicationContext applicationContext;
    private Environment environment;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }


    @Override
    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {

        AnnotationAttributes attributes = AnnotationAttributes.fromMap(
                annotationMetadata.getAnnotationAttributes(EnableTraceId.class.getName()));

        if (Objects.isNull(attributes)) {
            return;
        }

        String[] basePackage = attributes.getStringArray("basePackages");
        Enum<TraceIdUtils.TraceType> webPrefix = attributes.getEnum("webPrefix");

        if (Objects.nonNull(webPrefix) && environment instanceof StandardEnvironment) {
            Map<String, Object> source = Maps.newHashMap();
            source.put(TraceConstants.WEB_TRACEID_PREFIX, webPrefix.name());
            registerProperties((StandardEnvironment)environment, source);
        }
        // 扫描自动配置拦截器
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(registry);
        scanner.scan(basePackage);

    }

    private void registerProperties(StandardEnvironment environment, Map<String, Object> source) {

        String name = KafkaConsumerInterceptor.class.getName();
        source.put(TraceConstants.KAFKA_INTERCEPTOR, name);
        MutablePropertySources propertySources = environment.getPropertySources();
        propertySources.addLast(new MapPropertySource("autoConfig", source));
    }


}
