package com.kuaike.scrm.common.perm.interceptor;

import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.utils.ApiResult;
import com.kuaike.common.utils.ErrorCodeUtil;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.WebCommonUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.ServletUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.common.security.auth.Login;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Objects;

/**
 * @author sunwen
 */
@Slf4j
@Component
public class LoginInterceptor extends HandlerInterceptorAdapter {

	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
		if (!(handler instanceof HandlerMethod)) {
            // 访问URL不是后端接口(如图片网页资源)，无需权限验证
            return true;
        }
		boolean exist = LoginUtils.hasLoginNeedless(handler);
        if (exist) {
            return true;
        }

		LoginUtils.clear();
		LoginUtils.setSession(request.getSession());
		Long loginAccountId = LoginUtils.getLoginAccountId();
		log.debug("LoginInterceptor, LOGIN_ACCOUNT_ID:{}", loginAccountId);
		if (Objects.nonNull(loginAccountId)) {
			return true;
		}

		returnAjaxRepeatloginResponse(request, response);
		return false;
	}

	@Override
	public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
		LoginUtils.clear();
	}

	private void returnAjaxRepeatloginResponse(HttpServletRequest request, HttpServletResponse response) {
		WebCommonUtil.returnMessage(response, JacksonUtil.obj2Str(new ApiResult(
				ErrorCodeUtil.getUniverseErrorCode(CommonErrorCode.NO_LOGIN), "用户未登录",
				Collections.singletonMap("redirectUrl", ServletUtil.getBasePath(request) + "/login?service="))));
	}

}
