package com.kuaike.scrm.common.perm.service;

import java.util.List;
import java.util.Set;

/**
 * @author sunwen
 */
public interface UserRoleCommonService {

    /**
     * 获取管理部门集合(包含子部门)
     *
     * @return 部门id集合
     */
    Set<Long> getManageNodeIds();

    /**
     * 获取当前用户管理的部门id集合(包含用户自己)
     * @return
     */
    Set<Long> getManageUserIds();

    /**
     * 获取当前用户管理的部门id集合(包含用户自己)
     */
    Set<Long> getManageUserIdsByUserId(Long userId);


    /**
     * 根据项目模块， 侧边菜单， 菜单名获取用于这些菜单角色的人员
     * 排除系统管理员
     * @param rootName
     * @param sideTabName
     * @param menuName
     * @return
     */
    List<Long> getMenuRoleUserIds(Long bizId, String rootName, String sideTabName, String menuName);

    /**
     * 查询对某个userId有管理权限的用户。(包含用户自己)
     *
     * @param userId
     * @return
     */
    Set<Long> queryManagerUserIds(Long userId);

    /**
     * 获取用户的僵尸用户（之前已离职归档的用户，可以理解当前用户的前辈）
     */
    Set<Long> getZombieIds();
}
