package com.kuaike.trace.dubbo;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.*;
import com.kuaike.trace.utils.TraceIdUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 * @author louis
 * @date 2022/8/2
 * dubbo 支持透传traceId 拦截器
 */
@Slf4j
@Activate(group = {Constants.CONSUMER})
public class ConsumerTraceIdFilter implements Filter {
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        try {
            setTraceToContext();
            return invoker.invoke(invocation);
        } catch (RpcException e) {
            log.error("rpc invoke failed", e);
            return null;
        }
    }

    public void setTraceToContext() {
        String traceId = TraceIdUtils.getTraceId();
        log.debug("consumer setTraceId:{}", traceId);

        if (StringUtils.isNotBlank(traceId)) {
            RpcContext.getContext().setAttachment(TraceIdUtils.TRACE_ID, traceId);
        }
    }
}
