/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.trace.interceptor;

import com.kuaike.trace.utils.TraceIdUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumerInterceptor<K, V>
implements ConsumerInterceptor<K, V> {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumerInterceptor.class);

    public ConsumerRecords<K, V> onConsume(ConsumerRecords<K, V> records) {
        String traceId = TraceIdUtils.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            TraceIdUtils.removeTraceId();
        }
        traceId = TraceIdUtils.genAndSetTraceId(TraceIdUtils.TraceType.KAFKA);
        log.debug("=========kafka traceId:{}  =======", (Object)traceId);
        return records;
    }

    public void close() {
    }

    public void onCommit(Map offsets) {
    }

    public void configure(Map<String, ?> configs) {
    }
}

