package com.kuaike.scrm.common.perm.service;

import com.kuaike.scrm.common.perm.dto.AccessBizInfo;
import com.kuaike.scrm.common.perm.dto.AccessUserInfo;

public interface AccessPermitService {

    /**
     * 查询当前访问用户的权限信息
     *
     * @return 访问者的权限信息
     */
    AccessUserInfo getAccessUser();

    /**
     * 查询当前访问用户的商户权限信息
     *
     * @return 访问者的商户权限信息
     */
    AccessBizInfo getAccessBiz();

    /**
     * 检查当前访问者是否有权请求此接口
     *
     * @param requestUri 请求的接口地址
     * @return false 无权限 true 有权限
     */
    boolean checkPermission(String requestUri);
}
