package com.kuaike.scrm.common.perm.utils;

import org.apache.commons.lang3.StringUtils;

public final class PermUtils {

    // 禁止实例化
    private PermUtils() {}

    /**
     * 获取资源路径。如果当前系统有特定前缀，就在编码前加上前缀。
     *
     * @param prefix 服务前缀
     * @param uri 请求资源
     * @return 加上前缀后的资源路径
     */
    public static String getPathWithPrefix(String prefix, String uri) {
        // 加上系统默认前缀
        if (StringUtils.isNotBlank(prefix)) {
            return "/" + prefix + uri;
        }

        return uri;
    }

    /**
     * 获取权限编码。如果当前系统有特定前缀，就在编码前加上前缀。
     *
     * @param prefix 服务前缀
     * @param moduleId 模块权限
     * @param methodId 方法权限
     * @return 加上前缀后的权限编码
     */
    public static String getCodeWithPrefix(String prefix, int moduleId, long methodId) {
        StringBuilder builder = new StringBuilder();
        // 默认加上系统前缀
        if (StringUtils.isNotBlank(prefix)) {
            builder.append(prefix).append("-");
        }

        builder.append(moduleId);
        if (methodId < 10) {
            builder.append(0).append(methodId);
        } else {
            builder.append(methodId);
        }
        return builder.toString();
    }
}
