package com.kuaike.scrm.common.service;

import com.kuaike.common.dto.resp.Node;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * @author sunwen
 */
public interface NodeService {
    Map<Long, Node> getNodeMap(Long bizId);

    Set<Long> getPosterityIds(Long nodeId, Long bizId);

    /**
     * 获取部门以及其下的所有子部门
     *
     * @param nodeIds 部门id集合
     * @param bizId   商户id
     * @return 部门及子部门集合
     */
    Set<Long> getPosterityIds(Collection<Long> nodeIds, Long bizId);

    void clearCache(Long bizId);

    Node getNode(Long nodeId, Long bizId);
}
