package com.kuaike.scrm.common.enums.approve;

import com.kuaike.scrm.common.enums.EnumService;

//申请单状态：1-审批中；2-已通过；3-已驳回；4-已撤销；6-通过后撤销；7-已删除；10-已支付
public enum SpStatus implements EnumService {
    APPROVE(1, "审批中"),

    PASS(2, "已通过"),

    REFUSE(3, "已驳回"),

    CANCEL(4, "已撤销"),

    PASS_CANCEL(5, "通过后撤销"),

    DELETE(6, "已删除"),

    PAID(10, "已支付")
    ;


    private int value;

    private String desc;


    SpStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }


    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}
