package com.kuaike.scrm.vip.dto.enums;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 通用消息类型
 * 
 * @title WeworkCommonMsgType
 * @author yanmaoyuan
 * @date 2020年11月16日
 * @version 1.0
 */
public enum WeworkCommonMsgType {

    APPLY_ADD_FRIEND_EVENT(10001, "被动加好友上报"),

    WEWORK_CHAT_ROOM_ADDED(10002, "新增群上报"),

    MEMBER_CHANGED_EVENT(10003, "群成员变化上报")

    ;

    private final int type;

    private final String desc;

    private static final Map<Integer, WeworkCommonMsgType> MAP;

    private static final Set<Integer> TYPES;

    static {
        TYPES = Arrays.stream(values()).map(WeworkCommonMsgType::getType).collect(Collectors.toSet());
        MAP = Arrays.stream(values()).collect(Collectors.toMap(WeworkCommonMsgType::getType, Function.identity()));
    }

    WeworkCommonMsgType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static WeworkCommonMsgType getMsgType(Integer type) {
        return MAP.get(type);
    }

    public static boolean contains(int type) {
        return TYPES.contains(type);
    }
}
