package com.kuaike.scrm.common.enums;

import org.apache.commons.lang3.StringUtils;

public enum SettingEnum {

    UNKNOWN(0, "unknow", "未知"),
    MOBILE_ENCRYPT(1, "mobileEncrypt", "手机号中间4位加密"),
    RECOMMEND_SETTING(2, "wiseRecommendNumPerDay", "推送设置"),
    SHARE_CUSTOMER(3,"shareCustomer","客资共享"),
    REFUND_WAY(10,"refundWay","退款方式"),
    ORDER_PAY_NOTIFY(11, "orderPayNotify", "订单支付通知")
    ;

    public static SettingEnum getEnum(String enumName) {
        if (StringUtils.isBlank(enumName)) {
            return SettingEnum.UNKNOWN;
        }

        for (SettingEnum value : values()) {
            if (value.getName().equals(enumName)) {
                return value;
            }
        }
        return SettingEnum.UNKNOWN;
    }


    private int id;
    private String name;
    private String desc;

    SettingEnum(int id, String name, String desc) {
        this.id = id;
        this.name = name;
        this.desc = desc;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getDesc() {
        return desc;
    }
}
