package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum HandleQyAccountType implements EnumService{
    CLOSE(0, "关闭御珍堂SCRM"),
    OPEN(1, "开通御珍堂SCRM");

    private final int value;
    private final String desc;

    HandleQyAccountType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, HandleQyAccountType> CACHE;

    static {
        CACHE = new HashMap<>();
        for (HandleQyAccountType item : values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static HandleQyAccountType get(int status) {
        return CACHE.get(status);
    }

}
