package com.kuaike.scrm.common.enums;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Created by chenjiaqiang on 2022/05/05
 **/
public enum GoodsOrderSource {

    WX_SHOP(1, "微信小商店"),

    MEETING_COMMERCE(2, "直播带货商品定单"),
    YOU_ZAN(3, "有赞"),
    DOU_DIAN(4, "抖店"),
    TAO_BAO(5, "淘宝"),
    IMPORT(6, "手工录入"),
    NET_SCHOOL(7,"网校")
    ;

    private static final Map<Integer, GoodsOrderSource> cache;

    static {
        cache = new HashMap<>(2);
        for (GoodsOrderSource item : GoodsOrderSource.values()) {
            cache.put(item.getSource(), item);
        }
    }

    public static Collection<Integer> all() {
        return cache.keySet();
    }

    private final int source;

    private final String desc;

    public int getSource() {
        return source;
    }

    public String getDesc() {
        return desc;
    }

    GoodsOrderSource(int source, String desc) {
        this.source = source;
        this.desc = desc;
    }
}
