package com.kuaike.scrm.vip.dto.util;

import org.apache.commons.lang3.StringUtils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @description:
 * @author: liuguohong
 * @create: 2020/12/03 21:04
 */

public final class MsgUtil {
    public static final String ADD_FRINED_BY_MOBILE_MESSAGE = "我通过了你的朋友验证请求，现在我们可以开始聊天了";
    public static final Pattern FRIEND_IS_JOINED_PATTERN = Pattern.compile("你已添加了(.*?)，现在可以开始聊天了。");
    public static final Pattern JOINED_BY_FRIEND_PATTERN = Pattern.compile("(.*?)刚刚把你添加到通讯录，现在可以开始聊天了。");
    public static final Pattern GROUP_YOU_ARE_OWNER_PATTERN = Pattern.compile("你已成为新群主");
    public static final Pattern GROUP_YOU_ARE_KICKED_PATTERN = Pattern.compile("你被\"(.*?)\"移出群聊");
    public static final Pattern GROUP_STRANGER_PATTERN = Pattern.compile("\"(.*?)\"与群里其他人都不是微信朋友关系，请注意隐私安全");
    public static final Pattern AT_MEMBER_PATTERN = Pattern.compile("@.\\S+?[\\s|\\u2005]{1}?|@.\\S+?$");
    public static final Pattern OFFICIAL_ACCOUNT_ID = Pattern.compile("^gh_[0-9a-z]{12}$");
    public static final Pattern WEWORK_ID = Pattern.compile("^\\d+@im.chatroom$");

    private MsgUtil() {
        // Do not instance this class
    }

    public static boolean match(String message, Pattern pattern) {
        if (StringUtils.isBlank(message)) {
            return false;
        } else {
            Matcher matcher = pattern.matcher(message);
            return matcher.matches();
        }
    }

    public static String getJoinFriendNickName(String text) {
        int end;
        if (match(text, FRIEND_IS_JOINED_PATTERN)) {
            int begin = "你已添加了".length();
            end = text.length() - "，现在可以开始聊天了。".length();
            return text.substring(begin, end);
        } else if (match(text, JOINED_BY_FRIEND_PATTERN)) {
            int begin = 0;
            end = text.length() - "刚刚把你添加到通讯录，现在可以开始聊天了。".length();
            return text.substring(begin, end);
        } else {
            return null;
        }
    }

}
