/**
 * kuaikeguanjia.com Inc. Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.scrm.vip.dto.enums;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author yanmaoyuan
 * @version 1.0
 * @title WeworkSystemEnums
 * @date 2020年11月16日
 */
public enum WeworkSystemEnums {

    MANAGER(1, "scrm-manager"),

    APP(2, "scrm-app");

    private int type;

    private String name;

    private String desc;

    private static final Map<Integer, WeworkSystemEnums> MAP;

    private static final Set<String> TYPES;

    static {
        MAP = new HashMap<>();
        TYPES = new HashSet<>();

        for (WeworkSystemEnums e : values()) {
            MAP.put(e.getType(), e);
            TYPES.add(e.getName());
        }
    }

    private WeworkSystemEnums(int type, String name) {
        this(type, name, "");
    }

    private WeworkSystemEnums(int type, String name, String desc) {
        this.type = type;
        this.name = name;
        this.desc = desc;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public static WeworkSystemEnums getMsgType(Integer type) {
        return MAP.get(type);
    }

    public static boolean contains(String system) {
        return TYPES.contains(system);
    }
}
