package com.kuaike.scrm.vip.dto.enums;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * 通用消息类型
 * 
 * @title WeworkCommonMsgType
 * @author yanmaoyuan
 * @date 2020年11月16日
 * @version 1.0
 */
public enum WeworkCommonMsgType {

    APPLY_ADD_FRIEND_EVENT(10001, "被动加好友上报"),

    WEWORK_CHAT_ROOM_ADDED(10002, "新增群上报"),

    MEMBER_CHANGED_EVENT(10003, "群成员变化上报")

    ;

    private int type;

    private String desc;

    private static final Map<Integer, WeworkCommonMsgType> MAP;

    private static final Set<Integer> TYPES;

    static {
        MAP = new HashMap<>();
        TYPES = new HashSet<>();

        for (WeworkCommonMsgType e : values()) {
            MAP.put(e.getType(), e);
            TYPES.add(e.getType());
        }
    }

    private WeworkCommonMsgType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static WeworkCommonMsgType getMsgType(Integer type) {
        return MAP.get(type);
    }

    public static boolean contains(int type) {
        return TYPES.contains(type);
    }
}
