package com.kuaike.scrm.vip.dto.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 群发消息重试类型
 */
public enum MessageSendRetryType {

    TASK(0, "消息Task表ID, 重发整个任务中失败的消息"),
    DETAIL(1, "消息detail表id，重发单条消息");

    private Integer value;
    private String desc;

    private static Map<Integer, MessageSendRetryType> map = Maps.newHashMap();

    static {
        for (MessageSendRetryType type : MessageSendRetryType.values()) {
            map.put(type.value, type);
        }
    }

    public static MessageSendRetryType getType(Integer type) {
        return map.get(type);
    }

    public static Integer getValueByDesc(String desc) {
        for (MessageSendRetryType type : MessageSendRetryType.values()) {
            if (desc.equals(type.getDesc())) {
                return type.getValue();
            }
        }
        return null;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    MessageSendRetryType(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

}
