package com.kuaike.scrm.vip.dto.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @description:
 * @author: liuguohong
 * @create: 2020/11/28 15:13
 */
@SuppressWarnings("java:S3066")
public enum LabelSyncStatus {
    UN_SYNC(0, "未同步"),

    SYNC(1, "已同步");

    private int value;

    private String desc;

    LabelSyncStatus(int value, String desc) {
        this.desc = desc;
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    private static Map<Integer, LabelSyncStatus> map = Maps.newHashMap();

    static {
        for (LabelSyncStatus updateType :
                LabelSyncStatus.values()) {
            map.put(updateType.value, updateType);
        }
    }

    public static LabelSyncStatus getLabelSyncStatus(Integer type) {
        return map.get(type);
    }
}
