package com.kuaike.scrm.vip.dto.enums;

import com.google.common.collect.ImmutableMap;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: liuguohong
 * @create: 2020/06/06 14:41
 */

public enum AddFriendType {
    INITIATIVE_ADD_FRIEND(1, "主动加好友"),
    PASSIVE_ADD_FRIEND(2, "被动加好友");

    Integer value;
    String desc;

    private static final Map<Integer, AddFriendType> MAP;

    static {
        MAP = ImmutableMap.copyOf(
                Arrays.stream(AddFriendType.values()).collect(Collectors.toMap(AddFriendType::getValue, Function.identity())));
    }

    AddFriendType(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static AddFriendType getQuitType(Integer value) {
        return MAP.get(value);
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
