package com.kuaike.scrm.common.enums.applet;

import com.google.common.collect.Maps;
import lombok.Getter;

import java.util.Map;

/**
 * @author Created by chenjiaqiang on 2022/01/22
 * 小程序官方审核状态
 **/
@Getter
public enum WxAppletAuditStatus {

    /**
     * 小程序审核通过
     */
    WEAPP_AUDIT_SUCCESS(1,"weapp_audit_success"),

    /**
     * 小程序审核不通过
     */
    WEAPP_AUDIT_FAIL(2,"weapp_audit_fail"),

    /**
     * 审核延后
     */
    WEAPP_AUDIT_DELAY(3,"weapp_audit_delay")

    ;

    private Integer status;
    private String desc;

    WxAppletAuditStatus(Integer status, String desc){
        this.status = status;
        this.desc = desc;
    }

    private static Map<Integer, WxAppletAuditStatus> map = Maps.newHashMap();

    static {
        for (WxAppletAuditStatus status : WxAppletAuditStatus.values()) {
            map.put(status.status, status);
        }
    }

    public static boolean isExistByStatus(int type){
        return map.containsKey(type);
    }
}