package com.kuaike.scrm.common.enums.applet;

import com.google.common.collect.Maps;
import lombok.Getter;

import java.util.Map;

/**
 * @author Created by chenjiaqiang on 2022/01/21
 * 小程序授权状态
 **/
@Getter
public enum AppletAuthStatus {

    /**
     * 未授权
     */
    UNAUTHORIZED(0,"未授权"),
    AUTHORIZED(1,"已授权"),

    ;

    private Integer status;
    private String desc;

    AppletAuthStatus(Integer status, String desc){
        this.status = status;
        this.desc = desc;
    }

    private static Map<Integer, AppletAuthStatus> map = Maps.newHashMap();

    static {
        for (AppletAuthStatus status : AppletAuthStatus.values()) {
            map.put(status.status, status);
        }
    }

    public static boolean isExistByStatus(int type){
        return map.containsKey(type);
    }
}