package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 */

public enum WeworkRoleTypeEnum implements EnumService {
    NORMAL(1, "普通员工"),
    ADMIN(2, "超级管理员"),
    PERSON_IN_CHARGE(3, "负责人"),
    ;

    private int id;
    private String desc;

    WeworkRoleTypeEnum(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, WeworkRoleTypeEnum> cache;

    static {
        cache = new HashMap<>(3);
        for (WeworkRoleTypeEnum item : WeworkRoleTypeEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static WeworkRoleTypeEnum get(int id) {
        return cache.get(id);
    }
}