package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 */

public enum WeworkAuthEnum implements EnumService {
    AUTH(1, "已授权"),
    NOT_AUTH(0, "未授权");

    private int value;
    private String name;

    WeworkAuthEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, WeworkAuthEnum> cache;

    static {
        cache = new HashMap<>();
        for (WeworkAuthEnum item : WeworkAuthEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static WeworkAuthEnum get(int value) {
        return cache.get(value);
    }
}
