package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum WeekDayEnums implements EnumService {
    MON(1, "周一"),
    TUES(2, "周二"),
    WED(3, "周三"),
    THRU(4, "周四"),
    FRI(5, "周五"),
    SAT(6, "周六"),
    SUN(7, "周日");

    private int id;
    private String desc;

    WeekDayEnums(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, WeekDayEnums> cache;

    static {
        cache = new HashMap<>(3);
        for (WeekDayEnums item : WeekDayEnums.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static WeekDayEnums get(Integer status) {
        return cache.get(status);
    }

    public static String getWeekDayDesc(Integer status) {
        return Optional.ofNullable(cache.get(status)).map(WeekDayEnums::getDesc).orElse(null);

    }
}
