package com.kuaike.scrm.common.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 任务状态
 * 0：启用，1：禁用
 */
public enum TaskStatus {

    NORMAL(1, "启用"),
    BANED(0, "禁用");

    private Integer value;
    private String desc;

    private static Map<Integer, TaskStatus> map = Maps.newHashMap();

    static {
        for (TaskStatus type : TaskStatus.values()) {
            map.put(type.value, type);
        }
    }

    public static TaskStatus getType(Integer type) {
        return map.get(type);
    }

    public static Integer getValueByDesc(String desc) {
        for (TaskStatus type : TaskStatus.values()) {
            if (desc.equals(type.getDesc())) {
                return type.getValue();
            }
        }
        return null;
    }

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    TaskStatus(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

}
