package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;


/**
 * @author sunwen
 * 系统默认角色类型
 */
public enum SystemRoleType implements EnumService {
    ADMIN(1, "系统管理员"),
    NORMAL(2, "普通用户");

    private int id;
    private String name;

    SystemRoleType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, SystemRoleType> cache;

    static {
        cache = new HashMap<>(2);
        for (SystemRoleType item : SystemRoleType.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static SystemRoleType get(int status) {
        return cache.get(status);
    }
}
