package com.kuaike.scrm.common.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * author: jw
 * date: 2022/5/31 上午10:09
 * content:
 */
public enum SysChannelEnum {
    QY_WEIXIN("qyweixin", "企业微信", 1),

    ORDER_CENTER("orderCenter", "订单中心",1),

    AD_DELIVER("adDeliver", "广告投放",1),

    DYNAMIC_FORM("dynamicForm", "动态表单",1),

    LIVE_COMMERCE("liveCommerce", "直播带货",1),

    /**
     * 360广告平台
     */
    AD_360("ad360","360",0),

    /**
     * 哔哩哔哩广告平台
     */
    AD_BILI("adBiLi","B站",0),

    /**
     * 喜马拉雅广告平台
     */
    AD_XI_MA("adXiMa","喜马拉雅",0),

    /**
     * 字节巨量引擎广告平台
     */
    AD_OCEAN_ENGINE("adOceanEngine","字节巨量引擎",0),

    /**
     * 快手磁力引擎广告平台
     */
    AD_CI_LI_ENGINE("adCiLiEngine", "快手磁力引擎", 0),

    ;

    private String code;

    private String desc;

    /**
     * 是否为内置渠道
     */
    private Integer isInner;

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getIsInner() {
        return isInner;
    }

    SysChannelEnum(String code, String desc,Integer isInner) {
        this.code = code;
        this.desc = desc;
        this.isInner = isInner;
    }

    public static SysChannelEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        SysChannelEnum[] values = SysChannelEnum.values();
        for (SysChannelEnum value : values) {
            if (StringUtils.equals(value.getCode(), code)) {
                return value;
            }
        }
        return null;
    }

    public static SysChannelEnum getInnerChannelByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        SysChannelEnum[] values = SysChannelEnum.values();
        for (SysChannelEnum value : values) {
            if (YnEnum.YES.getValue().equals(value.getIsInner()) && StringUtils.equals(value.getCode(), code)) {
                return value;
            }
        }
        return null;
    }


}
