package com.kuaike.scrm.common.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 发送状态
 * -1：待查询， 0：待发送，1：发送中，2：已发送; 3:失败
 */
public enum SendStatus implements EnumService {

    TO_BE_QUERY(-1, "待查询"),
    TO_BE_SEND(0, "待发送"),
    SENDING(1, "发送中"),
    ALREADY_SEND(2, "已发送"),
    ALREADY_EXPIRE(3, "已过期"),
    SEND_FAIL(4, "发送失败"),
    ;

    private Integer value;
    private String desc;

    private static Map<Integer, SendStatus> map = Maps.newHashMap();

    static {
        for (SendStatus type : SendStatus.values()) {
            map.put(type.value, type);
        }
    }

    public static SendStatus getType(Integer type) {
        return map.get(type);
    }

    public static SendStatus getTypeForWeb(Integer type) {
        if (type != null && type == TO_BE_QUERY.getValue()) {
            return TO_BE_SEND;
        }
        return map.get(type);
    }

    public static Integer getValueByDesc(String desc) {
        for (SendStatus type : SendStatus.values()) {
            if (desc.equals(type.getDesc())) {
                return type.getValue();
            }
        }
        return null;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    SendStatus(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

}
