package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 *
 * 接替状态枚举类
 */
public enum RoomStatus implements EnumService{

    NORMAL(1, "正常"),
    BREAK_UP(2, "解散");

    private int id;
    private String name;

    RoomStatus(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, RoomStatus> cache;

    static {
        cache = new HashMap<>(2);
        for (RoomStatus item : RoomStatus.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static RoomStatus get(int status) {
        return cache.get(status);
    }
}
