package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum QualityBehaviorType {

    NONE(0,"none"),

    RED_PACKAGE(1, "发红包"),

    CARD(2,"发名片"),

    DEL_CONTACT(3,"删除好友"),

    DEL_BY_CONTACT(4,"被好友删除"),

    TIMEOUT_UNREPLY(5, "超时未回复"),

    ;

    private Integer type;

    private String desc;

    QualityBehaviorType(Integer type, String desc){
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, QualityBehaviorType> MAP;

    static {
        MAP = Arrays.stream(QualityBehaviorType.values()).collect(Collectors.toMap(a -> a.getType(), a -> a));
    }

    public static QualityBehaviorType getByType(int type) {
        return MAP.get(type);
    }
}
