package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum ParamEncryTypeEnum implements EnumService {
    MEETING_TYPE(1, "直播加密"),
    ORDER_TYPE(2, "订单详情加密"),
    MEETING_PAYBACK_TYPE(3, "直播回放加密");

    private int id;
    private String desc;

    private ParamEncryTypeEnum(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, ParamEncryTypeEnum> cache;

    static {
        cache = new HashMap<>(3);
        for (ParamEncryTypeEnum item : ParamEncryTypeEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static ParamEncryTypeEnum get(int status) {
        return cache.get(status);
    }
}
