package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum NoticeType {

    SYSTEM(0, "系统消息"),

    CRM_APPOINTMENT(1, "CRM预约消息");

    private int type;

    private String desc;

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    NoticeType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, NoticeType> MAP;

    static {
        MAP = Arrays.stream(NoticeType.values()).collect(Collectors.toMap(NoticeType::getType, Function.identity()));
    }

    public static NoticeType getByType(int type) {
        return MAP.get(type);
    }
}
