package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum MeetingCountType implements EnumService{
    PREDICT_REMIND_NUM(1,"预计通知人数"),
    REAL_REMIND_NUM(2,"实际通知人数"),
    JOIN_NUM(3,"入会人数"),
    UNJOIN_MEETING(4,"截止当前未入会人数");

    private int value;
    private String desc;

    MeetingCountType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, MeetingCountType> cache;

    static {
        cache = new HashMap<>(4);
        for (MeetingCountType item : MeetingCountType.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static MeetingCountType get(int status) {
        return cache.get(status);
    }
}
