package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum MaterialType implements EnumService{
    IMAGE(1, "image"),
    FILE(2, "file"),
    VOICE(3, "voice"),
    VIDEO(4, "video");

    private int value;
    private String desc;

    MaterialType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, MaterialType> cache;


    static {
        cache = new HashMap<>(4);
        for (MaterialType item : MaterialType.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static MaterialType get(int status) {
        return cache.get(status);
    }

}
