package com.kuaike.scrm.common.enums;

public enum LoginErrorType implements EnumService{
    CORP_UN_AUTH(101,"企业未授权第三方应用"),
    CANCEL_AUTH(102,"企业取消授权"),
    USER_UN_AUTH(103,"登录失败，员工账号未授权"),
    UN_ENABLE_ACCOUNT(104,"账号已禁用"),
    OVER_LIMIT(105,"登录失败，账号超过限制"),
    USER_UN_SYNC(106,"登录失败，员工账号未同步"),
    LOGIN_SUCCESS(0,"登录成功")

    ;

    private int value;
    private String desc;

    LoginErrorType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}
