package com.kuaike.scrm.common.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author zhangjing
 * @date 2021/5/31 4:17 下午
 */
@SuppressWarnings("squid:S115")
public enum JsMsgType {
    // 官方消息类型
    text,

    image,

    video,

    file,

    news,

    miniprogram,
    // 业务消息类型
    meeting,

    ffWords,

    voice,

    notice;

    final static Set<String> sets;

    static {
        sets = Arrays.stream(JsMsgType.values()).map(a -> a.name().toLowerCase(Locale.getDefault())).collect(Collectors.toSet());
    }

    public static boolean contains(String typeName) {
        if (StringUtils.isBlank(typeName)) {
            return false;
        }
        return sets.contains(typeName.toLowerCase(Locale.getDefault()));
    }

    public static String getMsgName(JsMsgType typeName) {
        switch (typeName) {
            case text:
                return "文本";
            case image:
                return "图片";
            case video:
                return "视频";
            case file:
                return "文件";
            case news:
                return "新闻";
            case miniprogram:
                return "小程序";
            case meeting:
                return "会议";
            case ffWords:
                return "好友裂变";
            case voice:
                return "语音";
            case notice:
                return "群公告";
            default:
                return "";
        }
    }
}
