package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhangjing
 * @date 2021/6/9 10:04 上午
 */
public enum GroupSendFkType {

    DEFAULT(0,"默认"),

    MEETING(1,"会议"),

    QRCODE_PULL(2,"活码拉群"),

    FRIEND_FISSION(3,"好友裂变"),

    SOP(10,"SOP"),

    UN_ARRIVE_MEETING(15,"未到课通知群发")

    ;

    private int type;

    private String desc;

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    GroupSendFkType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    static Map<Integer,GroupSendFkType> map;

    static {
        map = Arrays.stream(GroupSendFkType.values()).collect(Collectors.toMap(a->a.getType(), Function.identity()));
    }

    public static GroupSendFkType getInstance(int type){
        return map.get(type);
    }

}
