/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 标签拉群的入群状态
 * 
 * @title GroupInviteJoinStatus
 * @author yanmaoyuan
 * @date 2021年6月22日
 * @version 1.0
 */
public enum GroupInviteJoinStatus implements EnumService {

    NOT_SEND(0, "未入群"),

    SENT(1, "已入群")
    ;

    private int value;
    private String desc;

    private GroupInviteJoinStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private final static Map<Integer, GroupInviteJoinStatus> CACHE = new HashMap<>();

    static {
        for (GroupInviteJoinStatus e:values()) {
            CACHE.put(e.value, e);
        }
    }

    public static GroupInviteJoinStatus get(Integer value) {
        return CACHE.get(value);
    }
}
