package com.kuaike.scrm.common.enums;

import com.google.common.collect.Maps;
import lombok.Getter;

import java.util.Map;

/**
 * @author Created by chenjiaqiang on 2022/01/04
 *
 **/
@Getter
public enum GoodsValidType {

    /**
     * 指定时间范围生效
     */
    COUPON_VALID_TYPE_TIME(1,"指定时间范围生效","COUPON_VALID_TYPE_TIME"),
    COUPON_VALID_TYPE_DAY(2,"生效天数","COUPON_VALID_TYPE_DAY")

    ;

    private Integer type;
    private String desc;
    private String enDesc;

    GoodsValidType(Integer type, String desc, String enDesc){
        this.type = type;
        this.desc = desc;
        this.enDesc = enDesc;
    }

    private static Map<Integer, GoodsValidType> map = Maps.newHashMap();
    private static Map<String, GoodsValidType> enMap = Maps.newHashMap();

    static {
        for (GoodsValidType type : GoodsValidType.values()) {
            map.put(type.type, type);
            enMap.put(type.enDesc,type);
        }
    }

    public static boolean isExistByType(int type){
        return map.containsKey(type);
    }

    public static String getDescByType(int type) {
        return map.containsKey(type) ? map.get(type).getDesc() : null;
    }

    public static Integer getTypeByEnDesc(String enDesc){
        return enMap.containsKey(enDesc)?enMap.get(enDesc).getType():-1;
    }

    public static String getEnDescByType(int type){
        return map.containsKey(type) ? map.get(type).getEnDesc() : null;
    }
}
