package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: 好友裂变标签规则
 * @author: lwl
 * @date: 2021/7/26
 **/
public enum FriendFissionTagRule implements EnumService{
    ALL(1,"全部"),
    INVITE_NUM(2,"邀请人数"),
    STAGE(3,"达成阶梯");

    private int value;
    private String desc;

    FriendFissionTagRule(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, FriendFissionTagRule> cache;


    static {
        cache = new HashMap<>(3);
        for (FriendFissionTagRule item : FriendFissionTagRule.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static FriendFissionTagRule get(int status) {
        return cache.get(status);
    }
}
