package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 *
 * 审批模版类型
 */
public enum FlowTemplateTypeEnum implements EnumService {
    PRODUCT_ONLINE(1, "产品上线"),
    RECORD_SCORE(2, "录成绩"),
    REFUND(3, "退款"),
    FEEDBACK(4, "反馈"),
    DISCOUNT(5, "优惠申请"),
    ABANDON_CONTRACT_APPLY(6, "废除合同申请"),
    ;

    private int value;
    private String name;

    FlowTemplateTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, FlowTemplateTypeEnum> cache;

    static {
        cache = new HashMap<>();
        for (FlowTemplateTypeEnum item : FlowTemplateTypeEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static FlowTemplateTypeEnum get(int value) {
        return cache.get(value);
    }
}
