package com.kuaike.scrm.common.enums;

import com.google.common.collect.ImmutableMap;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum AddWayType {
    UNKNOWN(0, "未知来源"),

    QRCODE(1, "扫描二维码"),

    USER_MOBILE(2, "搜索手机号"),

    SHARE_CARD(3, "名片分享"),

    CHAT_ROOM(4, "群聊"),

    MOBILE_CONTACTS(5, "手机通讯录"),

    WECHAT_CONTACTS(6, "微信联系人"),

    WECHAT_REQUEST(7, "来自微信的添加好友申请 "),

    THIRD_CUSTOMER(8, "安装第三方应用时自动添加的客服人员"),

    EMAIL(9, "搜索邮箱"),

    INSIDE_SHARE(201, "内部成员共享"),

    ADMIN_ALLOCATION(202, "管理员/负责人分配")
    ;

    private int value;
    private String desc;

    private static final Map<Integer, AddWayType> MAP;

    static {
        MAP = ImmutableMap.copyOf(
                Arrays.stream(AddWayType.values()).collect(Collectors.toMap(AddWayType::getValue, Function.identity())));
    }

    AddWayType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static AddWayType getType(Integer value) {
        return MAP.get(value);
    }

    public int getValue() {
        return value;
    }


    public String getDesc() {
        return desc;
    }
}
