package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @Date: 2021/10/27 17:15
 * @Author: dayu
 */

public enum SystemTypeEnum {

    UNKNOW(0, "unknow", "未知"),
    SCRM(  1, "scrm",  "scrm"),
    TRADE( 2, "trade", "商品订单"),
    CRM(   3, "crm",   "crm"),
    PAY(   4, "pay",   "支付"),
    AD(    5, "ad",    "广告");

    private int value;
    private String name;
    private String desc;

    SystemTypeEnum(int value, String name, String desc) {
        this.value = value;
        this.name = name;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, SystemTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (SystemTypeEnum item : SystemTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static SystemTypeEnum get(Integer value) {
        return CACHE.get(value);
    }
}