package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;


public enum ContactStatisticDataTypeEnum implements EnumService {
    TOTAL(1, "客户总数"),
    ADD(2, "新增客户数"),
    DEL(3, "流失客户数");

    private final int value;
    private final String desc;

    ContactStatisticDataTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, ContactStatisticDataTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>(2);
        for (ContactStatisticDataTypeEnum item : ContactStatisticDataTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static ContactStatisticDataTypeEnum get(int status) {
        return CACHE.get(status);
    }
}
