package com.kuaike.scrm.vip.dto.enums;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 系统参数名
 */
public enum SystemParamName {

    /**
     * 添加好友相关参数
     */
    MIN_ADD_FRIENDS_INTERVAL("minAddFriendsInterval", "主动添加好友时间间隔下限"),

    MAX_ADD_FRIENDS_INTERVAL("maxAddFriendsInterval", "主动添加好友时间间隔上限"),

    EVERY_DAY_ADD_FRIENDS_UPPER_LIMIT("everyDayAddFriendsUpperLimit", "每日主动添加好友上限"),

    MIN_PASSIVE_ADD_FRIENDS_INTERVAL("minPassiveAddFriendsInterval", "被动添加好友时间间隔下限"),

    MAX_PASSIVE_ADD_FRIENDS_INTERVAL("maxPassiveAddFriendsInterval", "被动添加好友时间间隔上限"),

    EVERYDAY_PASSIVE_ADD_FRIENDS_UPPER_LIMIT("everydayPassiveAddFriendsUpperLimit", "每日被动添加好友上限"),

    /**
     * 群发相关参数
     */
    EVERYDAY_GROUP_SEND_ROOM_NUM_UPPER_LIMIT("everydayGroupSendRoomNumUpperLimit", "每日每成员群发客户群次数上限"),

    EVERYDAY_GROUP_SEND_WEWORK_NUM_UPPER_LIMIT("everydayGroupSendWeworkNumUpperLimit", "每日每成员群发客户次数上限"),

    MIN_GROUP_SEND_MESSAGE_INTERVAL("minGroupSendMessageInterval", "每条消息发送时间间隔下限"),

    MAX_GROUP_SEND_MESSAGE_INTERVAL("maxGroupSendMessageInterval", "每条消息发送时间间隔上限"),

    /**
     * 建群相关参数
     */
    EVERYDAY_CREATE_ROOM_NUM_UPPER_LIMIT("everydayCreateRoomNumUpperLimit", "每日每成员自动建群数量上限"),

    MIN_CREATE_ROOM_INTERVAL("minCreateRoomInterval", "建群时间间隔下限"),

    MAX_CREATE_ROOM_INTERVAL("maxCreateRoomInterval", "建群时间间隔上限"),

    /**
     * 运营时间相关参数
     */
    SYSTEM_REST_ENABLED("systemRestEnabled", "系统休眠开启"),
    MIN_SYSTEM_REST_TIME("minSystemRestTime", "系统休眠时间下限"),
    MAX_SYSTEM_REST_TIME("maxSystemRestTime", "系统休眠时间上限"),

    /**
     * 自动回复相关配置
     */
    // 0-关闭, 1-开启
    FRIEND_REPLY_DEDUPLICATE_ENABLED("friendReplyDeduplicateEnabled", "私聊自动回复消息去重开关"),
    // 单位: 秒
    FRIEND_REPLY_DEDUPLICATE_TIME("friendReplyDeduplicateTime", "私聊自动回复消息去重时间间隔"),
    // 1-策略1，回复菜单共用户选择；2-策略2，只回复1条
    FRIEND_MULTIPLE_KEYWORD_STRATEGY("friendMultipleKeywordStrategy", "私聊多关键词回复策略"),
    // 0-关闭, 1-开启
    FRIEND_REPLY_CONTAINS_QUESTION("friendReplyContainsQuestion", "私聊自动回复是否需要包含问题"),

    // 0-关闭, 1-开启
    GROUP_REPLY_DEDUPLICATE_ENABLED("groupReplyDeduplicateEnabled", "群聊自动回复消息去重开关"),
    // 单位: 秒
    GROUP_REPLY_DEDUPLICATE_TIME("groupReplyDeduplicateTime", "群聊自动回复消息去重时间间隔"),
    // 1-策略1，回复菜单共用户选择；2-策略2，只回复1条
    GROUP_MULTIPLE_KEYWORD_STRATEGY("groupMultipleKeywordStrategy", "群聊多关键词回复策略"),
    // 0-关闭, 1-开启
    GROUP_REPLY_CONTAINS_QUESTION("groupReplyContainsQuestion", "自动回复是否需要包含问题"),
    // 0-关闭, 1-开启
    GROUP_REPLY_NEED_AT_ROBOT("groupReplyNeedAtRobot", "自动回复需要@机器人"),
    // 0-关闭, 1-开启
    GROUP_REPLY_SHOULD_AT_MEMBER("groupReplyShouldAtMember", "自动回复需要@提问者"),

    // 单位: 秒
    MIN_FRIEND_WELCOME_INTERVAL("minFriendWelcomeInterval", "加好友回复时间间隔下限"),
    // 单位: 秒
    MAX_FRIEND_WELCOME_INTERVAL("maxFriendWelcomeInterval", "加好友回复时间间隔下限"),

    // 单位: 秒
    MIN_CHAT_ROOM_WELCOME_INTERVAL("minChatRoomWelcomeInterval", "入群欢迎间隔下限"),
    // 单位: 秒
    MAX_CHAT_ROOM_WELCOME_INTERVAL("maxChatRoomWelcomeInterval", "入群欢迎间隔上限"),

    //
    CHAT_ROOM_WELCOME_INTERVAL_NUM("chatRoomWelcomeIntervalNum", "入群欢迎人数间隔"),

    /**
     * 默认情况下，不在setting表中配置，或者值为0时，表示 员工在多个SOP中时，已最近更新的SOP为准
     * 当值为1时，表示  员工在多个SOP中时，已最新创建的SOP为准
     */
    SOP_USER_EFFECTIVE_POLICY("sopUserEffectivePolicy", "营销SOP员工在哪个营销SOP中生效策略"),

    /**
     * 枚举类 MeetingLiveDeliveryAuthMode
     */
    MEETING_LIVE_DELIVERY_AUTH_MODE("meetingLiveDeliveryAuthMode","直播带货授权模式"),

    /**
     * 1:scheme
     * 2:link http
     * 默认 scheme
     */
    MEETING_LIVE_DELIVERY_APPLET_URL_TYPE("meetingLiveDeliveryAppletUrlType","直播带货小程序授权小程序链接类型");

    private static final Map<String, String> DESC_CACHE;

    private static final Set<String> NAME_CACHE;

    private static final Map<String, SystemParamName> CACHE;

    static {
        DESC_CACHE = Arrays.stream(values()).collect(Collectors.toMap(SystemParamName::getKey, SystemParamName::getDesc));
        NAME_CACHE = Arrays.stream(values()).map(SystemParamName::getKey).collect(Collectors.toSet());
        CACHE = Arrays.stream(values()).collect(Collectors.toMap(SystemParamName::getKey, Function.identity()));
    }

    String key;

    String desc;

    SystemParamName(String key, String desc) {
        this.key = key;
        this.desc = desc;
    }

    public String getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }

    public static String desc(String type) {
        return DESC_CACHE.getOrDefault(type, "");
    }

    public static SystemParamName getType(String type) {
        return CACHE.get(type);
    }

    public static boolean contain(String type) {
        return NAME_CACHE.contains(type);
    }
}
