package com.kuaike.scrm.common.enums.applet;

import com.google.common.collect.ImmutableMap;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author sunwen
 */
@Getter
public enum AppletLevelConfigTypeEnum {

    CATEGORY(1, "分类"),

    AREA(2, "地区");

    private final int type;
    private final String desc;

    AppletLevelConfigTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static final Map<Integer, AppletLevelConfigTypeEnum> CACHE;
    static {
        CACHE = Arrays.stream(values()).collect(Collectors.toMap(
                AppletLevelConfigTypeEnum::getType, Function.identity()));
    }

    public static AppletLevelConfigTypeEnum get(int type) {
        return CACHE.get(type);
    }
}
