package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: lwl
 * @date: 2022/9/23
 * @description: "是"和"否"
 **/
public enum YesOrNoEnum implements EnumService{
    NO(0,"否"),
    YES(1,"是");

    private final Integer value;
    private final String desc;
    YesOrNoEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, YesOrNoEnum> CACHE;
    static {
        CACHE = new HashMap<>();
        for (YesOrNoEnum item : YesOrNoEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static YesOrNoEnum get(int value) {
        return CACHE.get(value);
    }
}
