package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;


public enum SexEnum implements EnumService {
    UNKNOWN(0, "未知"),
    MALE(1, "男"),
    FEMALE(2, "女");

    private final int value;
    private final String desc;

    SexEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, SexEnum> CACHE;

    static {
        CACHE = new HashMap<>(2);
        for (SexEnum item : SexEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static SexEnum get(int status) {
        return CACHE.get(status);
    }
}
